/*
 * Decompiled with CFR 0.152.
 */
package com.ezhld.ezadsystem;

import android.database.Cursor;
import android.graphics.Color;
import android.net.Uri;
import com.ezhld.ezadsystem.bn;
import com.ezhld.ezadsystem.util.AdUtil;
import java.io.Serializable;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import org.json.JSONObject;

public final class AdItem
implements Serializable {
    private static final long serialVersionUID = 4290162747881253908L;
    public String jsonString;
    public String cid = "";
    public String aid = "";
    public String adtype = "";
    public String ctv_type = "";
    public String ctv_url = "";
    public String click_url = "";
    public String install_url = "";
    public String open_url = "";
    public String market_url = "";
    public String title = "";
    public String desc = "";
    public String optout_desc = "";
    public boolean open_external = false;
    public Date exp;
    public ArrayList target;
    public String act_nm = "";
    public ArrayList act_param = null;
    public String act_flags = "";
    public int fadeout_sec = 10;
    public String fadeout_event = "";
    public boolean push_lights = true;
    public boolean push_vibrate = true;
    public boolean push_sound = true;
    public boolean push_ongoing = false;
    public int push_icon = 0;
    public String attach_image = "";
    public String attach_icon = "";
    public String ad_cmd = "";
    public long reg_date = 0L;
    public String task_key = "default_key";
    public double bubble_aspect_ratio = 3.4;
    public double bubble_width_ratio = 0.9;
    public double wall_width_ratio = 1.0;
    public double wall_height_ratio = 1.0;
    public boolean bubble_hide_at_start = false;
    public boolean wall_hide_at_start = false;
    public int dialog_color = -9129405;
    public boolean dialog_ok_button_left = false;
    public boolean dialog_enable_content_click = false;

    public boolean isQueueableCmd() {
        return this.adtype.equalsIgnoreCase("bubble") || this.adtype.equalsIgnoreCase("wall") || this.adtype.equalsIgnoreCase("dialog") || this.ad_cmd.equalsIgnoreCase("ez_store") || this.ad_cmd.equalsIgnoreCase("show_optin") || this.ad_cmd.equalsIgnoreCase("update_info");
    }

    AdItem(JSONObject jSONObject) {
        Object object;
        this.jsonString = jSONObject.toString();
        this.cid = this.a(jSONObject, "cid");
        this.aid = this.a(jSONObject, "aid");
        this.adtype = this.a(jSONObject, "adtype");
        this.ctv_type = this.a(jSONObject, "ctv_type");
        this.ctv_url = this.a(jSONObject, "ctv_url");
        this.click_url = this.a(jSONObject, "click_url");
        this.market_url = this.a(jSONObject, "market_url");
        this.install_url = this.a(jSONObject, "install_url");
        this.open_url = this.a(jSONObject, "open_url");
        this.title = this.a(jSONObject, "title");
        this.desc = this.a(jSONObject, "desc");
        this.exp = AdItem.convertStringToDate(this.a(jSONObject, "exp"));
        this.optout_desc = this.a(jSONObject, "optout_desc");
        this.open_external = this.a(jSONObject, "open_external").equalsIgnoreCase("true");
        try {
            this.target = bn.a(this.cid, jSONObject.getJSONObject("target").getJSONArray("area"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.act_nm = this.a(jSONObject, "act_nm");
        this.act_flags = this.a(jSONObject, "act_flags");
        if (this.act_flags.length() == 0) {
            this.act_flags = "FLAG_ACTIVITY_SINGLE_TOP";
        }
        try {
            this.act_param = new ArrayList();
            object = jSONObject.getJSONArray("act_param");
            int n2 = 0;
            while (n2 < object.length()) {
                try {
                    JSONObject jSONObject2 = object.getJSONObject(n2);
                    HashMap<String, String> hashMap = new HashMap<String, String>();
                    hashMap.put("key", jSONObject2.getString("key"));
                    hashMap.put("val", jSONObject2.getString("val"));
                    this.act_param.add(hashMap);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ++n2;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.fadeout_sec = (int)this.a(jSONObject, "fadeout_sec", 10L);
        this.fadeout_event = this.a(jSONObject, "fadeout_event");
        this.push_lights = !this.a(jSONObject, "push_lights").equalsIgnoreCase("false");
        this.push_vibrate = !this.a(jSONObject, "push_vibrate").equalsIgnoreCase("false");
        this.push_sound = !this.a(jSONObject, "push_sound").equalsIgnoreCase("false");
        this.push_ongoing = this.a(jSONObject, "push_ongoing").equalsIgnoreCase("true");
        this.push_icon = AdUtil.getJsonInt(jSONObject, "push_icon");
        this.attach_image = this.a(jSONObject, "attach_image");
        this.attach_icon = this.a(jSONObject, "attach_icon");
        this.ad_cmd = this.a(jSONObject, "ad_cmd");
        this.bubble_aspect_ratio = this.a(jSONObject, "bubble_aspect_ratio", 3.4);
        this.bubble_width_ratio = this.a(jSONObject, "bubble_width_ratio", 0.9);
        this.wall_width_ratio = this.a(jSONObject, "wall_width_ratio", 1.0);
        this.wall_height_ratio = this.a(jSONObject, "wall_height_ratio", 1.0);
        this.bubble_hide_at_start = this.a(jSONObject, "bubble_hide_at_start", 0L) != 0L;
        this.wall_hide_at_start = this.a(jSONObject, "wall_hide_at_start", 0L) != 0L;
        object = this.a(jSONObject, "dialog_color");
        if (((String)object).length() > 0) {
            this.dialog_color = Color.parseColor((String)object);
        }
        this.dialog_ok_button_left = this.a(jSONObject, "dialog_ok_button_left", 0L) != 0L;
        this.dialog_enable_content_click = this.a(jSONObject, "dialog_enable_content_click", 0L) != 0L;
    }

    AdItem(Cursor cursor) {
        this(new JSONObject(AdItem.a(cursor, "json")));
        this.jsonString = AdItem.a(cursor, "json");
        try {
            this.reg_date = cursor.getLong(cursor.getColumnIndex("reg_date"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static String a(Cursor cursor, String string) {
        try {
            return cursor.getString(cursor.getColumnIndex(string));
        }
        catch (Exception exception) {
            return "";
        }
    }

    private String a(JSONObject jSONObject, String string) {
        try {
            String string2 = jSONObject.getString(string);
            return string2 == null ? "" : string2;
        }
        catch (Exception exception) {
            return "";
        }
    }

    private long a(JSONObject jSONObject, String string, long l2) {
        try {
            return jSONObject.getLong(string);
        }
        catch (Exception exception) {
            return l2;
        }
    }

    private double a(JSONObject jSONObject, String string, double d2) {
        try {
            return Double.parseDouble(jSONObject.getString(string));
        }
        catch (Exception exception) {
            return d2;
        }
    }

    public int getNotificationDefaults() {
        boolean bl2 = false;
        int n2 = 0;
        if (this.push_lights) {
            n2 |= 4;
        }
        if (this.push_sound && !bl2) {
            n2 |= 1;
        }
        if (this.push_vibrate && !bl2) {
            n2 |= 2;
        }
        return n2;
    }

    public int getNotificationFlags() {
        int n2 = 24;
        if (this.push_ongoing) {
            n2 |= 2;
        }
        return n2;
    }

    public static String updateURLParam(String string) {
        try {
            Uri uri = Uri.parse((String)string);
            String string2 = uri.getHost().toLowerCase(Locale.ENGLISH);
            if (!string2.contains("ezadsystem.com")) {
                return string;
            }
            String string3 = string.replace(uri.getQuery(), "");
            String[] stringArray = uri.getQuery().split("&");
            int n2 = 0;
            while (n2 < stringArray.length) {
                try {
                    String[] stringArray2 = stringArray[n2].split("=");
                    String string4 = stringArray2[1];
                    if (!stringArray2[0].equalsIgnoreCase("tm")) {
                        string3 = String.valueOf(string3) + String.format("%s=%s&", stringArray2[0], URLEncoder.encode(string4, "UTF-8"));
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ++n2;
            }
            try {
                String string5 = new SimpleDateFormat("yyyyMMddHHmmss", Locale.ENGLISH).format(new Date());
                string3 = String.valueOf(string3) + String.format("%s=%s", "tm", URLEncoder.encode(string5, "UTF-8"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            return string3;
        }
        catch (Exception exception) {
            return string;
        }
    }

    public static Date convertStringToDate(String string) {
        try {
            return new SimpleDateFormat("yyyyMMdd", Locale.ENGLISH).parse(string);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String convertDateToString(Date date) {
        try {
            return new SimpleDateFormat("yyyyMMdd", Locale.ENGLISH).format(date);
        }
        catch (Exception exception) {
            return "";
        }
    }
}

