package com.example.ezadsystemexample;

import android.app.Activity;
import android.os.Bundle;

import com.ezhld.ezadsystem.EzAdSystem;
import com.ezhld.ezadsystem.util.AdUtil;


public class MainActivity extends Activity
{
	@Override
	protected void onCreate(Bundle savedInstanceState)
	{
		super.onCreate(savedInstanceState);
		setContentView(R.layout.activity_main);
		
		// 테스트모드 활성화 - 배포전에 반드시 제거하시기 바랍니다.
		EzAdSystem.setTestMode(true);
		
		// Bubble 광고의 아래쪽 마진을 설정합니다. 사용하지 않을 경우 해상도에 적절한 마진이 자동으로 적용됩니다. 아래는 30dp를 적용한 예입니다.
		EzAdSystem.setBubbleBottomMargin(AdUtil.DP2PX(this, 30));
		
		// Store 광고의 색상을 지정합니다. 기본값은 YELLOW입니다.
		// ARGB, 예) 0xFFFF0000 - 빨간색
		EzAdSystem.setStoreColor(EzAdSystem.STORE_TITLE_COLOR_DEFAULT, EzAdSystem.STORE_BACK_COLOR_YELLOW);
		
		// 사용가능한 Locale을 설정합니다.
		// 사용하지 않을 경우 모든 Locale에서 동작합니다.		
		//EzAdSystem.addAvailableLocale(Locale.KOREA);
		
		// SDK를 생성및 초기화합니다.
		EzAdSystem.create(this);
		
		// Push광고를 위한 동의창을 띄웁니다.
		// 서버의 설정에 따라 동작하지 않을 수도 있습니다.
		EzAdSystem.showOptin(this);
		
		// Bubble/Dialog/Wall 등 앱시작시 표시될 광고및 버전관리기능을 사용하기 위해 호출합니다.
		// 앱시작시 노출될 광고(Bubble/Dialog/Wall)및 버전관리(업데이트 유도창, 기본값은 사용안함)는 
		// 관리자 웹페이지에서 설정이 가능합니다.
		EzAdSystem.hello(this); 
	}
	
	@Override
	protected void onDestroy()
	{
		super.onDestroy();
		
		// 사용하지 않아도 무방하나 사용하지 않을 경우 popup/dialog가 사라지기 전에 해당 Activity가 종료될 경우 Leak이 발생할 수 있습니다.
		EzAdSystem.destroyAllPopup();
	}
	
	// 종료시점, Wall/Store 광고를 수신하고자 할때
	@Override
	public void onBackPressed()
	{
		//super.onBackPressed(); - 주석처리를 합니다.
		
		// Activity가 종료(사용자가 인지하는 종료)되는 시점에 Wall/Store 광고를 수신합니다.
		EzAdSystem.requestBye(this);

		// 또는 EzAdSystem.requestBye(this, "닫기", "앱종료", true);
		// 버튼 이름을 넘깁니다.
		// 마지막 인자는 광고창에서 back키가 눌러졌을시 앱을 종료하고싶으시면 true 아니면 false를 넘깁니다.
	}
}
